<?php $__env->startPush('libraries_top'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="section-header">
            <h1><?php echo e(trans('update.bundles')); ?> <?php echo e(trans('admin/main.list')); ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(getAdminPanelUrl()); ?>"><?php echo e(trans('admin/main.dashboard')); ?></a>
                </div>
                <div class="breadcrumb-item"><?php echo e(trans('update.bundles')); ?></div>
            </div>
        </div>

        <div class="section-body">

            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-primary">
                            <i class="fas fa-cube"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(trans('admin/main.total')); ?> <?php echo e(trans('update.bundles')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e($totalBundles); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-warning">
                            <i class="fas fa-eye"></i>
                        </div>

                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(trans('admin/main.pending_review')); ?> <?php echo e(trans('update.bundles')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e($totalPendingBundles); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-success">
                            <i class="fas fa-dollar-sign"></i></div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(trans('admin/main.total_sales')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e(!empty($totalSales) ? number_format($totalSales->total_amount, 2) : 0); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-info">
                            <i class="fas fa-shopping-cart"></i></div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(trans('admin/main.total_orders')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e(!empty($totalSales) ? $totalSales->sales_count : 0); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <section class="card">
                <div class="card-body">
                    <form method="get" class="mb-0">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(trans('admin/main.search')); ?></label>
                                    <input name="title" type="text" class="form-control" value="<?php echo e(request()->get('title')); ?>">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(trans('admin/main.start_date')); ?></label>
                                    <div class="input-group">
                                        <input type="date" id="from" class="text-center form-control" name="from" value="<?php echo e(request()->get('from')); ?>" placeholder="Start Date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(trans('admin/main.end_date')); ?></label>
                                    <div class="input-group">
                                        <input type="date" id="to" class="text-center form-control" name="to" value="<?php echo e(request()->get('to')); ?>" placeholder="End Date">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label"></label>
                                    <button class="btn btn-primary btn-block" type="submit"><?php echo e(trans('admin/main.search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </section>

            <div class="row">
                <div class="col-12">

                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo e(trans('update.bundles')); ?></h4>

                            <div class="card-header-action">
                                <a href="<?php echo e(getAdminPanelUrl()); ?>/bundles/create" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(trans('admin/main.new')); ?></a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin/main.id')); ?></th>
                                        <th><?php echo e(trans('public.title')); ?></th>
                                        <th><?php echo e(trans('admin/main.teacher')); ?></th>
                                        <th><?php echo e(trans('admin/main.category')); ?></th>
                                        <th><?php echo e(trans('admin/main.courses')); ?></th>
                                        <th><?php echo e(trans('admin/main.price')); ?></th>
                                        <th><?php echo e(trans('admin/main.sales')); ?></th>
                                        <th><?php echo e(trans('admin/main.status')); ?></th>
                                        <th><?php echo e(trans('admin/main.actions')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $bundles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($bundle->id); ?></td>
                                            <td>
                                                <a href="<?php echo e(getAdminPanelUrl()); ?>/bundles/<?php echo e($bundle->id); ?>/edit"><?php echo e($bundle->title); ?></a>
                                            </td>
                                            <td><?php echo e($bundle->teacher->full_name ?? '-'); ?></td>
                                            <td><?php echo e($bundle->category->title ?? '-'); ?></td>
                                            <td><span class="badge badge-info"><?php echo e($bundle->bundle_webinars_count ?? 0); ?></span></td>
                                            <td><?php echo e(number_format($bundle->price ?? 0, 2)); ?></td>
                                            <td>
                                                <?php echo e($bundle->sales->count()); ?>

                                            </td>
                                            <td>
                                                <?php if($bundle->status == \App\Models\Bundle::$active): ?>
                                                    <span class="badge badge-success"><?php echo e(trans('admin/main.active')); ?></span>
                                                <?php elseif($bundle->status == \App\Models\Bundle::$pending): ?>
                                                    <span class="badge badge-warning"><?php echo e(trans('admin/main.pending')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger"><?php echo e(trans('admin/main.inactive')); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(getAdminPanelUrl()); ?>/bundles/<?php echo e($bundle->id); ?>/edit" class="btn btn-sm btn-info" title="<?php echo e(trans('admin/main.edit')); ?>"><i class="fas fa-edit"></i></a>
                                                <a href="<?php echo e(getAdminPanelUrl()); ?>/bundles/<?php echo e($bundle->id); ?>/delete" class="btn btn-sm btn-danger delete-action" title="<?php echo e(trans('admin/main.delete')); ?>"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="100%" class="text-center">
                                                <p class="text-muted"><?php echo e(trans('admin/main.no_result_found')); ?></p>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <?php echo e($bundles->appends(request()->query())->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts_bottom'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/foxycieo/public_html/lms.foxytech.site/resources/views/admin/bundles/lists.blade.php ENDPATH**/ ?>