function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function () {
  "use strict";

  $('body').on('change', 'select[name="country_id"]', function () {
    var $this = $(this);
    $('select[name="province_id"]').val(null).prop('disabled', true);
    $('select[name="city_id"]').val(null).prop('disabled', true);
    $('select[name="district_id"]').val(null).prop('disabled', true);

    if ($this.val()) {
      $this.addClass('loadingbar gray').prop('disabled', true);
      $.get('/regions/provincesByCountry/' + $this.val(), function (result) {
        if (result && result.code === 200) {
          var selectBox = $('select[name="province_id"]');
          var html = '<option value="">' + selectProvinceLang + '</option>';

          if (result.provinces && result.provinces.length) {
            var _iterator = _createForOfIteratorHelper(result.provinces),
                _step;

            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var province = _step.value;
                html += '<option value="' + province.id + '">' + province.title + '</option>';
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }
          }

          selectBox.prop('disabled', false);
          selectBox.html(html);
          $this.removeClass('loadingbar gray').prop('disabled', false);
        }
      });
    }
  });
  $('body').on('change', 'select[name="province_id"]', function () {
    var $this = $(this);
    $('select[name="city_id"]').val(null).prop('disabled', true);
    $('select[name="district_id"]').val(null).prop('disabled', true);

    if ($this.val()) {
      $this.addClass('loadingbar gray').prop('disabled', true);
      $.get('/regions/citiesByProvince/' + $this.val(), function (result) {
        if (result && result.code === 200) {
          var selectBox = $('select[name="city_id"]');
          var html = '<option value="">' + selectCityLang + '</option>';

          if (result.cities && result.cities.length) {
            var _iterator2 = _createForOfIteratorHelper(result.cities),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var city = _step2.value;
                html += '<option value="' + city.id + '">' + city.title + '</option>';
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }

          selectBox.prop('disabled', false);
          selectBox.html(html);
          $this.removeClass('loadingbar gray').prop('disabled', false);
        }
      });
    }
  });
  $('body').on('change', 'select[name="city_id"]', function () {
    var $this = $(this);
    $('select[name="district_id"]').val(null).prop('disabled', true);

    if ($this.val()) {
      $this.addClass('loadingbar gray').prop('disabled', true);
      $.get('/regions/districtsByCity/' + $this.val(), function (result) {
        if (result && result.code === 200) {
          var selectBox = $('select[name="district_id"]');
          var html = '<option value="">' + selectDistrictLang + '</option>';

          if (result.districts && result.districts.length) {
            var _iterator3 = _createForOfIteratorHelper(result.districts),
                _step3;

            try {
              for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                var district = _step3.value;
                html += '<option value="' + district.id + '">' + district.title + '</option>';
              }
            } catch (err) {
              _iterator3.e(err);
            } finally {
              _iterator3.f();
            }
          }

          selectBox.prop('disabled', false);
          selectBox.html(html);
          $this.removeClass('loadingbar gray').prop('disabled', false);
        }
      });
    }
  });
})(jQuery);
