function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

(function ($) {
  "use strict"; // added in forms.js

  /*$('body').on('click', '.panel-file-manager', function (e) {
      e.preventDefault();
      $(this).filemanager('file', {prefix: '/laravel-filemanager'});
  });*/

  $('body').on('change', 'select[name="role"]', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var $instructorLabel = $('.js-instructor-label');
    var $organizationLabel = $('.js-organization-label');
    var type = "become_organization";

    if (value === 'teacher') {
      $organizationLabel.addClass('d-none');
      $instructorLabel.removeClass('d-none');
      type = "become_instructor";
    } else {
      $organizationLabel.removeClass('d-none');
      $instructorLabel.addClass('d-none');
    }

    $.post('/become-instructor/form-fields', {
      type: type
    }, function (result) {
      if (result) {
        $('.js-form-fields-card').html(result.html);
        formsDatetimepicker();
        feather.replace();
      }
    });
  });
  $('body').on('change', 'input[name="id"]', function (e) {
    e.preventDefault();
    $('button#paymentSubmit').removeAttr('disabled');
    var packageId = $(this).val();
    checkPackageHasInstallment(packageId);
  });

  function checkPackageHasInstallment(id) {
    var path = '/become-instructor/packages/' + id + '/checkHasInstallment';
    var $btn = $('.js-installment-btn');
    $btn.addClass('d-none');
    $.get(path, function (result) {
      if (result && result.has_installment) {
        $btn.removeClass('d-none');
        $btn.attr('href', '/become-instructor/packages/' + id + '/installments');
      }
    });
  }

  $('body').on('change', '.js-user-bank-input', function (e) {
    e.preventDefault();
    var $optionSelected = $(this).find("option:selected");
    var specifications = $optionSelected.attr('data-specifications');
    var $card = $('.js-bank-specifications-card');
    var html = '';

    if (specifications) {
      Object.entries(JSON.parse(specifications)).forEach(function (_ref, key) {
        var _ref2 = _slicedToArray(_ref, 2),
            index = _ref2[0],
            item = _ref2[1];

        html += '<div class="form-group">\n' + '         <label class="font-weight-500 text-dark-blue">' + item + '</label>\n' + '         <input type="text" name="bank_specifications[' + index + ']" value="" class="form-control"/>\n' + ' </div>';
      });
    }

    $card.html(html);
  });
})(jQuery);
