/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!***********************************************!*\
  !*** ./resources/js/panel/meeting/meeting.js ***!
  \***********************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  function substringText($element, am_pm) {
    var val = $element.val();
    var time = val.substring(0, val.length - 2);
    $element.val(time + am_pm);
    return time;
  }

  // toTimepicker and fromTimepicker are defined globally in blade

  function handleToTime() {
    var justPM = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    var $timeTwelveSwitch = $('#timeTwelveSwitch');
    $timeTwelveSwitch.prop('checked', justPM);
    if (justPM) {
      $timeTwelveSwitch.prop('disabled', true);
    }
    toTimepicker = $('.to-clockpicker').clockpicker({
      placement: 'bottom',
      align: 'left',
      "default": '10:00AM',
      autoclose: true,
      twelvehour: true,
      afterDone: function afterDone() {
        handleFromTome();
        toTimepicker.clockpicker('remove');
        fromTimepicker.clockpicker('show');
        var to_time = $('.to-clockpicker input');
        var am_pm = $('.to-time .js-am-pm').text();
        $('.to-time').removeClass('pulsate').html(substringText(to_time, am_pm) + ' <span class="js-am-pm font-20">' + am_pm + '</span>');
        $timeTwelveSwitch.prop('disabled', true);
      }
    });
  }
  handleToTime();
  function handleFromTome() {
    $('#timeTwelveSwitch').prop('checked', false);
    fromTimepicker = $('.from-clockpicker').clockpicker({
      placement: 'bottom',
      align: 'left',
      autoclose: true,
      "default": '09:00AM',
      twelvehour: true,
      afterDone: function afterDone() {
        var isPM = $('#timeTwelveSwitch').is(":checked");
        handleToTime(isPM);
        fromTimepicker.clockpicker('remove');
        toTimepicker.clockpicker('show');
        var from_time = $('.from-clockpicker input');
        var am_pm = $('.from-time .js-am-pm').text();
        $('.from-time').removeClass('pulsate').html(substringText(from_time, am_pm) + ' <span class="js-am-pm font-20">' + am_pm + '</span>');
        $('.to-time').addClass('pulsate');
        if (isPM) {
          handlePMAM('PM', 'AM');
        }
      }
    });
    fromTimepicker.clockpicker('show');
  }
  function handlePMAM(type, replace) {
    var $fromText = $('.from-time.pulsate').find('.js-am-pm');
    var $toText = $('.to-time.pulsate').find('.js-am-pm');
    if ($fromText.length) {
      $fromText.text(type);
      var $from = $('.from-clockpicker input');
      var from_time = $from.val();
      from_time = from_time.replace(replace, type);
      $from.val(from_time);
    }
    if ($toText.length) {
      $toText.text(type);
      var $to = $('.to-clockpicker input');
      var to_time = $to.val();
      to_time = to_time.replace(replace, type);
      $to.val(to_time);
    }
  }
  $('body').on('change', '#timeTwelveSwitch', function (e) {
    e.preventDefault();
    var type = 'AM';
    var replace = 'PM';
    if (this.checked) {
      type = 'PM';
      replace = 'AM';
    }
    handlePMAM(type, replace);
  });
  $('body').on('click', '.add-time', function (e) {
    e.preventDefault();
    var day = $(this).closest('tr').attr('data-day');
    var add_time_html = "\n        <div class=\"add-time-modal\">\n            <div class=\"add-time-sheet row flex-column-reverse flex-lg-row align-items-center justify-content-center justify-content-lg-between\">\n                <div class=\"clock-box col-12 col-lg-4 d-block position-relative d-flex align-items-center justify-content-center justify-content-lg-start\">\n                    <div class=\"from-clockpicker\">\n                        <input type=\"hidden\" class=\"form-control \" value=\"03:00AM\">\n                    </div>\n                    <div class=\"to-clockpicker\">\n                        <input type=\"hidden\" class=\"form-control \" value=\"04:00AM\">\n                    </div>\n                </div>\n                <div class=\"col-12 col-lg-8\">\n                    <div class=\"row\">\n                        <div class=\"col-12 col-lg-4 mb-20 mb-lg-0 d-flex align-items-center justify-content-center custom-control custom-switch on-off-switch pl-0 py-0 py-lg-50\">\n                            <label style=\"margin-right: 60px\">AM</label>\n                            <input type=\"checkbox\" class=\"custom-control-input\" id=\"timeTwelveSwitch\">\n                            <label class=\"custom-control-label\" for=\"timeTwelveSwitch\">PM</label>\n                        </div>\n\n                        <div class=\"col-12 col-lg-8 d-flex flex-column align-items-center justify-content-center py-0 py-lg-50\">\n                            <div class=\"font-48 text-primary from-time pulsate\">03:00 <span class=\"js-am-pm font-16\">AM</span></div>\n                            <div class=\"font-weight-500 text-dark-blue\">To</div>\n                            <div class=\"font-48 text-primary to-time\">04:00 <span class=\"js-am-pm font-16\">AM</span></div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"row justify-content-end\">\n                <div class=\"col-12 col-lg-6\">\n                    <div class=\"form-group mt-10\">\n                        <label class=\"input-label\">".concat(meetingTypeLang, "</label>\n                        <select class=\"form-control\" name=\"meeting_type\">\n                            <option value=\"all\">").concat(bothLang, "</option>\n                            <option value=\"in_person\">").concat(inPersonLang, "</option>\n                            <option value=\"online\">").concat(onlineLang, "</option>\n                        </select>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"input-label\">").concat(descriptionLng, "</label>\n                <textarea name=\"description\" class=\"form-control\" rows=\"5\" placeholder=\"").concat(saveTimeDescriptionPlaceholder, "\"></textarea>\n            </div>\n\n            <div class=\"mt-30 d-flex align-items-center justify-content-end\">\n                <button type=\"button\" data-day=\"").concat(day, "\" id=\"saveTime\" class=\"btn btn-sm btn-primary\">").concat(saveLang, "</button>\n                <button type=\"button\" class=\"btn btn-sm btn-danger ml-10 close-swl\">").concat(closeLang, "</button>\n            </div>\n        </div>\n        ");
    Swal.fire({
      html: add_time_html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '48rem',
      onOpen: function onOpen() {
        setTimeout(function () {
          handleFromTome();
        }, 300);
      },
      onClose: function onClose() {
        fromTimepicker.clockpicker('remove');
        toTimepicker.clockpicker('remove');
      }
    });
  });
  $('body').on('click', '#saveTime', function (e) {
    e.preventDefault();
    var $this = $(this);
    var from_time = $('.from-clockpicker input').val();
    var to_time = $('.to-clockpicker input').val();
    var day = $this.attr('data-day');
    var $modal = $this.closest('.add-time-modal');
    var meetingType = $modal.find('select[name="meeting_type"]').val();
    var description = $modal.find('textarea[name="description"]').val();
    $this.addClass('loadingbar primary').prop('disabled', true);
    var data = {
      day: day,
      time: from_time + '-' + to_time,
      meeting_type: meetingType,
      description: description
    };
    $.post('/panel/meetings/saveTime', data, function (result) {
      if (result && result.registration_package_limited) {
        handleLimitedAccountModal(result.registration_package_limited);
      } else if (result && result.code == 200) {
        Swal.fire({
          title: deleteAlertSuccess,
          text: successSavedTime,
          showConfirmButton: false,
          icon: 'success'
        });
        setTimeout(function () {
          window.location.reload();
        }, 1000);
      }
    }).fail(function () {
      Swal.fire({
        title: errorSavingTime,
        text: noteToTimeMustGreater,
        icon: 'error'
      });
      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).always(function () {
      fromTimepicker.clockpicker('remove');
      toTimepicker.clockpicker('remove');
    });
  });
  $('body').on('change', '#inPersonMeetingSwitch', function () {
    var inPersonMeetingAmount = $('#inPersonMeetingAmount');
    var inPersonGroupMeetingOptions = $('#inPersonGroupMeetingOptions');
    if (this.checked) {
      inPersonMeetingAmount.removeClass('d-none');
      if ($('#groupMeetingSwitch').is(':checked')) {
        inPersonGroupMeetingOptions.removeClass('d-none');
      }
    } else {
      inPersonMeetingAmount.addClass('d-none');
      inPersonGroupMeetingOptions.addClass('d-none');
    }
  });
  $('body').on('change', '#groupMeetingSwitch', function () {
    var onlineGroupMeetingOptions = $('#onlineGroupMeetingOptions');
    var inPersonGroupMeetingOptions = $('#inPersonGroupMeetingOptions');
    if (this.checked) {
      onlineGroupMeetingOptions.removeClass('d-none');
      if ($('#inPersonMeetingSwitch').is(':checked')) {
        inPersonGroupMeetingOptions.removeClass('d-none');
      }
    } else {
      onlineGroupMeetingOptions.addClass('d-none');
      inPersonGroupMeetingOptions.addClass('d-none');
    }
  });
  function deleteTimeModal(time_id) {
    var html = '<div class="">\n' + '    <p class="">' + deleteAlertHint + '</p>\n' + '    <div class="mt-30 d-flex align-items-center justify-content-center">\n' + '        <button type="button" id="deleteTime" data-time-id="' + time_id + '" class="btn btn-sm btn-primary">' + deleteAlertConfirm + '</button>\n' + '        <button type="button" class="btn btn-sm btn-danger ml-10 close-swl">' + deleteAlertCancel + '</button>\n' + '    </div>\n' + '</div>';
    Swal.fire({
      title: deleteAlertTitle,
      html: html,
      icon: 'warning',
      showConfirmButton: false,
      showCancelButton: false,
      allowOutsideClick: function allowOutsideClick() {
        return !Swal.isLoading();
      }
    });
  }
  $('body').on('click', '.remove-time', function (e) {
    e.preventDefault();
    var $this = $(this);
    var time_id = $this.attr('data-time-id');
    deleteTimeModal(time_id);
  });
  $('body').on('click', '#deleteTime', function (e) {
    e.preventDefault();
    var $this = $(this);
    var time_id = $this.attr('data-time-id');
    time_id = time_id.split(',');
    handleRemoveTime(time_id);
    Swal.close();
    var _iterator = _createForOfIteratorHelper(time_id),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var id = _step.value;
        $('.remove-time[data-time-id="' + id + '"]').parent().remove();
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  });
  function handleRemoveTime(time_id) {
    var data = {
      time_id: time_id
    };
    $.post('/panel/meetings/deleteTime', data, function (result) {
      $.toast({
        heading: deleteAlertSuccess,
        text: successDeleteTime,
        bgColor: '#43d477',
        textColor: 'white',
        hideAfter: 5000,
        position: 'bottom-right',
        icon: 'success'
      });
    }).fail(function () {
      $.toast({
        heading: deleteAlertFail,
        text: errorDeleteTime,
        bgColor: '#f63c3c',
        textColor: 'white',
        hideAfter: 5000,
        position: 'bottom-right',
        icon: 'error'
      });
    });
  }
  $('body').on('click', '.clear-all', function (e) {
    e.preventDefault();
    var parent = $(this).closest('tr');
    var timeIds = parent.find('.selected-time .remove-time').map(function () {
      return this.dataset.timeId;
    }).get();
    deleteTimeModal(timeIds.join(','));
  });
  $('body').on('change', '#temporaryDisableMeetingsSwitch', function (e) {
    e.preventDefault();
    var $this = $(this);
    loadingSwl();
    var disable = false;
    if (this.checked) {
      disable = true;
    }
    var data = {
      disable: disable
    };
    $.post('/panel/meetings/temporaryDisableMeetings', data, function (result) {
      if (result && result.code == 200) {
        Swal.fire({
          text: requestSuccess,
          showConfirmButton: false,
          icon: 'success'
        });
        setTimeout(function () {
          Swal.close();
        }, 2000);
      }
    }).fail(function () {
      Swal.fire({
        text: requestFailed,
        icon: 'error'
      });
      $this.removeClass('loadingbar primary').prop('disabled', false);
    });
  });
  $('body').on('click', '#meetingSettingFormSubmit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = serializeObjectByTag($form);
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveMeetingSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;