/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*********************************************!*\
  !*** ./resources/js/admin/personal_note.js ***!
  \*********************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-show-note', function (e) {
    e.preventDefault();
    var $this = $(this);
    var note = $this.parent().find('input').val();
    var html = '<div class="">' + '<h3 class="section-title after-line">' + noteLang + '</h3>' + '<p class="text-gray mt-20">' + note + '</p>' + '</div>';
    Swal.fire({
      html: html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '40rem'
    });
  });
  $('body').on('click', '.js-edit-note', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $tr = $this.closest("tr");
    var action = $this.attr('data-action');
    var note = $tr.find('.js-note-message').val();
    var attachment = $tr.find('.js-note-attachment').val();
    var html = "<form action=\"".concat(action, "\" method=\"post\">\n            <div class=\"js-personal-notes-form text-left\">\n                <h4 class=\"font-14 font-weight-bold\">").concat(personalNoteLang, "</h4>\n\n                <textarea name=\"note\" rows=\"5\" class=\"form-control mt-1\">").concat(note !== null && note !== void 0 ? note : '', "</textarea>\n\n                <div class=\"form-group mt-15\">\n                    <label class=\"input-label\">").concat(attachmentLang, "</label>\n\n                    <div class=\"input-group mr-10\">\n                        <div class=\"input-group-prepend\">\n                            <button type=\"button\" class=\"input-group-text admin-file-manager\" data-input=\"personalNotesAttachment\" data-preview=\"holder\">\n                                <i class=\"fa fa-upload\"></i>\n                            </button>\n                        </div>\n                        <input type=\"text\" name=\"attachment\" id=\"personalNotesAttachment\" value=\"").concat(attachment !== null && attachment !== void 0 ? attachment : '', "\" class=\"form-control\" placeholder=\"\"/>\n                    </div>\n                </div>\n\n                <div class=\"d-flex align-items-center mt-15\">\n                    <button type=\"button\" class=\"js-save-personal-note btn btn-primary\">").concat(saveNoteLang, "</button>\n                    <button type=\"button\" class=\"btn btn-danger ml-2 close-swl\">").concat(closeLang, "</button>\n                </div>\n            </div>\n        </form>");
    Swal.fire({
      html: html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '40rem'
    });
  });
  $('body').on('click', '.js-save-personal-note', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          title: result.title,
          html: '<p class="font-16 text-center text-gray py-2">' + result.msg + '</p>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 1500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {}
    });
  });
})(jQuery);
/******/ })()
;